<!DOCTYPE html>
<html>
<head>
    <title>Domain Search</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        pre {
            background-color: #f8f9fa;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <form id="domainSearchForm">
        <input type="hidden" name="action" value="SearchDom">
        <label for="inputDomain">Domain:</label>
        <input type="text" id="inputDomain" name="inputDomain" required>
        <button type="submit">Search</button>
    </form>
    
    <div id="result">
        <pre id="jsonOutput"></pre>
    </div>

    <script>
        $(document).ready(function() {
            $('#domainSearchForm').on('submit', function(event) {
                event.preventDefault();
                var formData = $(this).serialize();

                $.ajax({
                    url: '/domainsearch/searchDomain',
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        $('#jsonOutput').text(JSON.stringify(response, null, 4));
                    },
                    error: function(xhr, status, error) {
                        var err = JSON.parse(xhr.responseText);
                        $('#jsonOutput').text(JSON.stringify(err, null, 4));
                    }
                });
            });
        });
    </script>
</body>
</html>