<?php

namespace App\Controllers;

use App\Models\LkdomainsModel;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\HTTP\Exceptions\HTTPException;

class DomainSearchController extends BaseController
{
    public function index()
    {
        return view('domain_search');
    }

    public function searchDomain()
    {
        if ($this->request->getMethod() === 'post') {
            $action = $this->request->getPost('action');
            if ($action == "SearchDom") {
                $domain = $this->request->getPost('inputDomain');
                // $lkdomainsModel = new LkdomainsModel();
                // $lkdomainsModel->insert(['domain' => $domain]);

                $companyKey = 'c45Y0vPPWrdskoy8EwkxbStFHTRYF8';
                $url = "https://api.domains.lk/searchdomain";
                
                $payload = json_encode(['domainname' => $domain]);

                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type:application/json',
                    'X-API-KEY:' . $companyKey
                ]);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $result = curl_exec($ch);
                curl_close($ch);

                $dm = json_decode($result);

                if (isset($dm->Required)) {
                    $data = [
                        'domain_name' => $dm->DomainName,
                        'message' => $dm->Message,
                        'price' => $dm->Required->Product->Price,
                        'type' => $dm->Required->Product->Name,
                        'domain_type_id' => $dm->Required->DomainTypeID,
                        'category_id' => $dm->Required->Category->ID,
                        'availability' => $dm->Required->Available,
                        'expire_date' => $dm->ExpireDate
                    ];
                    return $this->response->setJSON($data);
                } else {
                    return $this->response->setJSON(['error' => 'Invalid response from API']);
                }
            }
        }

        throw HTTPException::forMethodNotAllowed($this->request->getMethod());
    }
}